<?php
require_once("../layouts/members/head.php");
if ($user_data['Rc_pdf_services'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
             <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()" > <i class="fas fa-arrow-left"></i> Back</button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;
          $response = []; // Initialize response array

          if (isset($_POST['submit'])) {
              $vehicalNumber = strtoupper($_POST['vehicalNumber']);

              if (!empty($vehicalNumber)) {
                  $amount = $user_data['vehical_rc_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($user_data['balance'] >= $amount) {
                      $order_id = order_txn_id();
                      
                      // --- NEW API IMPLEMENTATION START ---
                      $apiKey = "APIKEYPASTEE"; // Buy APi From This Website https://apizone.co.in ( Design & Development By APIZONE )
                      $apiUrl = "https://kycapizone.in/api/v2/vehical_rc/rc_verify.php?api_key=" . $apiKey . "&rc_number=" . $vehicalNumber;

                      $curl = curl_init();
                      curl_setopt_array($curl, array(
                         CURLOPT_URL => $apiUrl,
                         CURLOPT_RETURNTRANSFER => true,
                         CURLOPT_ENCODING => '',
                         CURLOPT_MAXREDIRS => 10,
                         CURLOPT_TIMEOUT => 30,
                         CURLOPT_FOLLOWLOCATION => true,
                         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                         CURLOPT_CUSTOMREQUEST => 'GET',
                         CURLOPT_SSL_VERIFYPEER => false,
                      ));

                      $responseApi = curl_exec($curl);
                      curl_close($curl);
                      
                      $json_data = json_decode($responseApi, true) ?? [];

                      if (isset($json_data['status']) && $json_data['status'] == '100') {
                          
                          // Map API Result to $response array for compatibility
                          $apiResult = $json_data['result'];
                          
                          $response['status'] = '100';
                          $response['regNo'] = $apiResult['rc_number'] ?? $vehicalNumber;
                          $response['owner'] = $apiResult['name'] ?? 'NA';
                          $response['ownerFatherName'] = $apiResult['fathername'] ?? 'NA';
                          $response['presentAddress'] = $apiResult['address'] ?? 'NA';
                          // Map empty fields for others since new API doesn't provide them, to prevent undefined index errors
                          $response['permanentAddress'] = $apiResult['address'] ?? 'NA';
                          $response['chassis'] = '';
                          $response['engine'] = '';
                          $response['rcstatus'] = '';
                          $response['vehicleInsuranceCompanyName'] = '';
                          
                          $updateSuccess = db_update("members", ["balance" => $new_balance], " user_id='" . $user_data['user_id'] . "' ");

                          if ($updateSuccess) {
                              $printData = array(
                                  'regNo' => $response['regNo'],
                                  'owner' => $response['owner'],
                                  'ownerFatherName' => $response['ownerFatherName'],
                                  'chassis' => '',
                                  'engine' => '',
                                  'rcstatus' => 'Active',
                                  'rcStandardCap' => '',
                                  'vehicleInsuranceCompanyName' => '',
                                  'vehicleInsuranceUpto' => '',
                                  'vehicleInsurancePolicyNumber' => '',
                                  'rtoCode' => '',
                                  'permanentAddress' => $response['presentAddress'],
                                  'presentAddress' => $response['presentAddress'],
                                  'regDate' => '',
                                  'rcExpiryDate' => '',
                                  'ownerCount' => '',
                                  'type' => 'old',
                                  'fuel_descr' => '',
                                  'normsType' => '',
                                  'monthYearmfg' => '',
                                  'vehicleClass' => '',
                                  'vehicleCylindersNo' => '',
                                  'vehicleManufacturerName' => '',
                                  'model' => '',
                                  'vehicleColour' => '',
                                  'bodyType' => '',
                                  'vehicleSeatCapacity' => '2',
                                  'vehicleSleeperCapacity' => '0',
                                  'vehicleStandingCapacity' => '0',
                                  'unladenWeight' => '',
                                  'vehicleCubicCapacity' => '0',
                                  'vehicleCategory' => '',
                                  'grossVehicleWeight' => '',
                                  'horsepower' => '0',
                                  'wheelbase' => '0',
                                  'rcFinancer' => 'On Cash',
                                  'regAuthority' => '',
                                  'username'      => $user_data['username'],
                                  'pdf_url' => $apiResult['pdf'] ?? '' // Storing the base64 PDF provided by API
                              );
                              
                              $name = $response['owner'];

                               $Mremark = 'Name: ' . $name . " - Vehical Number: " . $vehicalNumber;
                               $insData = [
                                   'order_id'       => $order_id,
                                   'username'       => $user_data['username'],
                                   'name'           => $name,
                                   'idNumber'       => $vehicalNumber,
                                   'service'        => "VEHICALRCPDF",
                                   'date_time'      => current_timestamp(),
                                   'printData'      => base64_encode(str_replace("\\", "", json_encode($printData, JSON_UNESCAPED_UNICODE))),
                                   'photo'          => "",
                               ];

                               $insertIddata = db_insert("printRecords", $insData);
    
                               if ($insertIddata) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "VEHICALRCPDF",
                                  'type'          => "Debit",
                                  'account_number'=> $response['regNo'],
                                  'app_type'      => "VEHICALRCPDF",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $response['regNo'],
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for Name {$response['owner']} RC Number ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                  $fields = [
                                      'regNo' => 'Vehical No',
                                      'owner' => 'Name',
                                      'ownerFatherName' => 'Father',
                                      'presentAddress' => 'Address',
                                  ];

                                  $whamessage = "Dear {$user_data['name']},\nYour Request for Vehical Number *{$vehicalNumber}* has been Complete.\n\n";

                                  foreach ($fields as $key => $label) {
                                      if (!empty($response[$key]) && $response[$key] != 'NA') {
                                          $whamessage .= "*$label*: {$response[$key]}\n";
                                      }
                                  }
                                  $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                   send_sms($user_data['mobile'],$whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                              awal_alert_msg("Data Fetch Successful from '.$Mremark.'.", 'success');
                                // Use a small timeout to allow the modal to be seen or data to save before redirect
                                echo "<script>setTimeout(function(){ window.location.href='printRecord'; }, 3000);</script>";
                            } else {
                                 awal_alert_msg("Saving Data Error!", 'error');
                             }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          // Handle API error
                          $msg = $json_data['message'] ?? 'Server Down or Data Not Found';
                          awal_alert_msg($msg, 'error');
                      }
                      // --- NEW API IMPLEMENTATION END ---
                      
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Vehical Number</label>
              <input type="text" name="vehicalNumber" placeholder="Enter Vehical Number" maxlength="15" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" onkeypress="if(this.value.length==15) return false;" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary" ><i class="fas fa-inr"></i> <?php echo $user_data['vehical_rc_fee'];?></button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
              <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#showDetailsModal">Show</button>
            </div>
          </form>
        </div>
      </div>
    </div>
</div>

<div class="modal fade" id="showDetailsModal" tabindex="-1" role="dialog" aria-labelledby="showDetailsModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="showDetailsModalLabel">Fetched Details</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
    <?php if (isset($response['owner']) && !empty($response['owner'])) { ?>
          <form class="row">
            <div class="col-md-6 mb-3">
              <label>Name</label>
              <input type="text" value="<?= htmlspecialchars($response['owner']) ?>" class="form-control" readonly>
              </div>
            <div class="col-md-6 mb-3">
              <label>Father Name</label>
              <input type="text" value="<?= htmlspecialchars($response['ownerFatherName']) ?>" class="form-control" readonly>
            </div>
            <div class="col-md-12 mb-3">
              <label>Address</label>
              <input type="text" value="<?= htmlspecialchars($response['presentAddress']) ?>" class="form-control" readonly>
            </div>
          </form>
        <?php } else { ?>
          <p>No details fetched yet. Submit Vehical Number to Details.</p>
        <?php } ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
  <?php if (isset($response['owner']) && !empty($response['owner'])) { ?>
    $(document).ready(function() {
      $('#showDetailsModal').modal('show');
    });
  <?php } ?>
</script>

<?php
} else {
    require_once("404.php");
}
} else {
    awal_alert_msg('You Do Not Have Any Vehical Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>